<?php

declare(strict_types=1);

namespace RhysLeesLtd\LaravelDefault\Traits;

use Illuminate\Database\Eloquent\Concerns\HasUuids;

trait HasUuid
{
    use HasUuids;

    public function uniqueIds(): array
    {
        return ['uuid'];
    }

    public function getRouteKeyName(): string
    {
        return 'uuid';
    }

    public static function findByUuid($uuid)
    {
        return self::where('uuid', $uuid)->first();
    }

    public static function findByUuidOrFail($uuid)
    {
        return self::where('uuid', $uuid)->sole();
    }

    public function scopeWithUuid($query, $uuid)
    {
        return $query->where('uuid', $uuid);
    }

    public function scopeWithUuids($query, array $uuids)
    {
        return $query->whereIn('uuid', $uuids);
    }
}
