<?php

declare(strict_types=1);

namespace RhysLeesLtd\LaravelDefault\Providers;

use Override;
use Illuminate\Support\ServiceProvider;
use Spatie\Health\Checks\Checks\CacheCheck;
use Spatie\Health\Checks\Checks\DatabaseCheck;
use Spatie\Health\Checks\Checks\DebugModeCheck;
use Spatie\Health\Checks\Checks\EnvironmentCheck;
use Spatie\Health\Checks\Checks\FlareErrorOccurrenceCountCheck;
use Spatie\Health\Checks\Checks\OptimizedAppCheck;
use Spatie\Health\Checks\Checks\ScheduleCheck;
use Spatie\Health\Checks\Checks\UsedDiskSpaceCheck;
use Spatie\Health\Facades\Health;
use Spatie\SecurityAdvisoriesHealthCheck\SecurityAdvisoriesCheck;

class HealthServiceProvider extends ServiceProvider
{
    #[Override]
    public function register(): void
    {
        $checks = [
            DebugModeCheck::new(),
            CacheCheck::new(),
            OptimizedAppCheck::new(),
            DatabaseCheck::new(),
            EnvironmentCheck::new(),

            SecurityAdvisoriesCheck::new()
                ->weekly(),

            UsedDiskSpaceCheck::new()
                ->if(fn () => app()->environment('production')),

            ScheduleCheck::new()
                ->heartbeatMaxAgeInMinutes(5)
                ->if(fn () => app()->environment('production')),
        ];

        if (
            config('laravel-default.services.flare.enabled') &&
            config('laravel-default.services.flare.project_id') &&
            config('laravel-default.services.flare.api_token') &&
            in_array(app()->environment(), config('laravel-default.services.flare.environments'))
        ) {
            $checks[] = FlareErrorOccurrenceCountCheck::new()
                ->projectId(config('laravel-default.services.flare.project_id'))
                ->apiToken(config('laravel-default.services.flare.api_token'));
        }

        Health::checks($checks);
    }
}
