<?php

declare(strict_types=1);

namespace RhysLeesLtd\LaravelDefault\Policies;

use RhysLeesLtd\LaravelDefault\Policies\Presets\DataBlob;
use RhysLeesLtd\LaravelDefault\Policies\Presets\Development;
use RhysLeesLtd\LaravelDefault\Policies\Presets\DigitalOceanSpaces;
use RhysLeesLtd\LaravelDefault\Policies\Presets\Gravatar;
use RhysLeesLtd\LaravelDefault\Policies\Presets\UiAvatars;
use RhysLeesLtd\LaravelDefault\Policies\Presets\UnsafeInline;
use RhysLeesLtd\LaravelDefault\Policies\Presets\Userback;
use Spatie\Csp\Policy;
use Spatie\Csp\Preset;
use Spatie\Csp\Presets\Basic;
use Spatie\Csp\Presets\Fathom;
use Spatie\Csp\Presets\GoogleFonts;

class SecurityHeader implements Preset
{
    public function configure(Policy $policy): void
    {
        // Start with basic preset
        (new Basic())->configure($policy);
        
        // Add third-party service presets
        (new Fathom())->configure($policy);
        (new GoogleFonts())->configure($policy);
        
        // Add custom presets
        (new DigitalOceanSpaces())->configure($policy);
        (new Gravatar())->configure($policy);
        (new UiAvatars())->configure($policy);
        (new DataBlob())->configure($policy);
        (new UnsafeInline())->configure($policy);
        (new Userback())->configure($policy);
        
        // Add development preset conditionally
        if (app()->environment(['local', 'testing'])) {
            (new Development())->configure($policy);
        }
    }
}
