<?php

declare(strict_types=1);

namespace RhysLeesLtd\LaravelDefault\Policies\Presets;

use Spatie\Csp\Directive;
use Spatie\Csp\Policy;
use Spatie\Csp\Preset;

class DigitalOceanSpaces implements Preset
{
    public function configure(Policy $policy): void
    {
        // Only configure if DO environment variables are set
        if (! env('DO_BUCKET')) {
            return;
        }

        $endpoints = [
            env('DO_SUBDOMAIN_ENDPOINT', 'https://'.env('DO_BUCKET').'.'.env('DO_CDN_ENDPOINT', 'lon1.cdn.digitaloceanspaces.com')),
            'https://'.env('DO_ENDPOINT', 'lon1.digitaloceanspaces.com'),
            'https://'.env('DO_CDN_ENDPOINT', 'lon1.cdn.digitaloceanspaces.com'),
        ];

        $policy
            ->add([Directive::CONNECT, Directive::IMG, Directive::MEDIA], $endpoints);
    }
}
