<?php

declare(strict_types=1);

namespace RhysLeesLtd\LaravelDefault;

use RhysLeesLtd\LaravelDefault\Commands\GenerateSitemapCommand;
use RhysLeesLtd\LaravelDefault\Commands\InstallCommand;
use RhysLeesLtd\LaravelDefault\Commands\OhDearRequestRunCommand;
use RhysLeesLtd\LaravelDefault\Commands\OhDearStartMaintenanceCommand;
use RhysLeesLtd\LaravelDefault\Commands\OhDearStopMaintenanceCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class LaravelDefaultServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('laravel-default')
            ->hasConfigFile('laravel-default')
            ->hasCommands(
                InstallCommand::class,
                GenerateSitemapCommand::class,
                OhDearRequestRunCommand::class,
                OhDearStartMaintenanceCommand::class,
                OhDearStopMaintenanceCommand::class,
            )
            ->hasViews();
    }
}
