<?php

declare(strict_types=1);

namespace RhysLeesLtd\LaravelDefault;

use Illuminate\Console\Scheduling\Schedule;
use RhysLeesLtd\LaravelDefault\Commands\GenerateSitemapCommand;
use Spatie\Health\Commands\RunHealthChecksCommand;
use Spatie\Health\Commands\ScheduleCheckHeartbeatCommand;
use Spatie\ScheduleMonitor\Models\MonitoredScheduledTaskLogItem;

class LaravelDefault
{
    /**
     * Register the commands for the application.
     *
     * OhDear, Sitemap, Redis Cache
     */
    public function scheduleDefaultCommands(Schedule $schedule): void
    {
        // OhDear
        $schedule->command(command: ScheduleCheckHeartbeatCommand::class)
            ->everyMinute();

        $schedule->command(command: RunHealthChecksCommand::class)
            ->everyMinute();

        $schedule->command('model:prune', ['--model' => MonitoredScheduledTaskLogItem::class])
            ->daily();

        // SEO
        $schedule->command(command: GenerateSitemapCommand::class)
            ->daily();

        // Redis
        if (
            config('cache.default') == 'redis' ||
            config('queue.default') == 'redis' ||
            config('session.driver') == 'redis'
        ) {
            $schedule->command('cache:prune-stale-tags')
                ->hourly();
        }
    }
}
