<?php

declare(strict_types=1);

namespace RhysLeesLtd\LaravelDefault\Enums;

use Filament\Support\Contracts\HasLabel;
use RhysLeesLtd\LaravelDefault\Enums\Traits\HasArrays;

enum EnvironmentEnum: string implements HasLabel
{
    use HasArrays;
    
    case PRODUCTION = 'production';
    case STAGING = 'staging';
    case LOCAL = 'local';

    public function getLabel(): ?string
    {
        return match ($this) {
            self::PRODUCTION => 'Production',
            self::STAGING => 'Staging',
            self::LOCAL => 'Local',
        };
    }
}
