<?php

declare(strict_types=1);

namespace RhysLeesLtd\LaravelDefault\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;

class OhDearStartMaintenanceCommand extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'oh-dear:start-maintenance';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Request Oh Dear to start maintenance.';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        if (! config('laravel-default.services.oh_dear.enabled')) {
            $this->error('Oh Dear is disabled.');

            return;
        }

        if (! config('laravel-default.services.oh_dear.key')) {
            $this->error('Oh Dear token is not set.');

            return;
        }

        if (! config('laravel-default.services.oh_dear.site_id')) {
            $this->error('Oh Dear site ID is not set.');

            return;
        }

        $siteRequest = Http::withToken(config('laravel-default.services.oh_dear.key'))
            ->accept('application/json')
            ->contentType('application/json')
            ->post('https://ohdear.app/api/sites/'.config('laravel-default.services.oh_dear.site_id').'/start-maintenance');

        if (! $siteRequest->successful()) {
            $this->error('Oh Dear failed to start maintenance.');

            return;
        }

        $this->components->info('Oh Dear started maintenance.');
    }
}
