<?php

declare(strict_types=1);

namespace RhysLeesLtd\LaravelDefault\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;

class OhDearRequestRunCommand extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'oh-dear:request-run';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Request Oh Dear to run a check.';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        if (! config('laravel-default.services.oh_dear.enabled')) {
            $this->error('Oh Dear is disabled.');

            return;
        }

        if (! config('laravel-default.services.oh_dear.key')) {
            $this->error('Oh Dear token is not set.');

            return;
        }

        if (! config('laravel-default.services.oh_dear.site_id')) {
            $this->error('Oh Dear site ID is not set.');

            return;
        }

        $siteRequest = Http::withToken(config('laravel-default.services.oh_dear.key'))
            ->accept('application/json')
            ->contentType('application/json')
            ->get('https://ohdear.app/api/sites/'.config('laravel-default.services.oh_dear.site_id'));

        if (! $siteRequest->successful()) {
            $this->error('Oh Dear failed to get site.');

            return;
        }

        $checks = collect($siteRequest->json()['checks'])->map(fn ($check): mixed => in_array($check['type'], ['broken_links', 'mixed_content']) ? $check['id'] : null)->filter();

        $checks->each(function ($check): void {
            $check = Http::withToken(config('laravel-default.services.oh_dear.key'))
                ->accept('application/json')
                ->contentType('application/json')
                ->post('https://ohdear.app/api/checks/'.$check.'/request-run');

            if (! $check->successful()) {
                $this->error('Oh Dear failed to request a run of check: '.$check.'.');
            }

            $this->info('Oh Dear requested a run of check: '.$check.'.');
        });
    }
}
