<?php

declare(strict_types=1);

?>
@php
    $userbackConfig = config('laravel-default.services.userback');
    $shouldShowUserback = $userbackConfig['enabled'] 
        && in_array(app()->environment(), $userbackConfig['environments'])
        && $userbackConfig['access_token']
        && auth()->check();
@endphp

@if($shouldShowUserback)
    @php
        $user = auth()->user();
    @endphp

    <script>
        window.Userback = window.Userback || {};
        Userback.access_token = "{{ $userbackConfig['access_token'] }}";

        Userback.user_data = {
            id: '{{ $user?->id }}',
            info: {
                name: '{{ $user?->name }}',
                email: '{{ $user?->email }}',
            }
        };

        (function(d) {
            var s = d.createElement('script');
            s.async = true;
            s.src = 'https://static.userback.io/widget/v1.js';
            (d.head || d.body).appendChild(s);
        })(document);
    </script>
@endif
<?php 
