<?php

declare(strict_types=1);

?>
@props(['path' => '', 'color' => '#ffffff'])

{{-- Defaults --}}
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="csrf-token" content="{{ csrf_token() }}">

{{-- Fathom Analytics --}}
<x-default::fathom />

{{-- SEO --}}
{!! SEO::generate() !!}

{{-- Favicon https://realfavicongenerator.net --}}
<link rel="icon" type="image/png" sizes="96x96" href="{{ $path }}/favicon-96x96.png" />
<link rel="icon" type="image/svg+xml" href="{{ $path }}/favicon.svg" />
<link rel="shortcut icon" href="{{ $path }}/favicon.ico" />
<link rel="apple-touch-icon" sizes="180x180" href="{{ $path }}/apple-touch-icon.png" />
<meta name="apple-mobile-web-app-title" content="{{ config('app.name') }}" />
<link rel="manifest" href="{{ $path }}/site.webmanifest" />


<?php 
