<?php

declare(strict_types=1);

return [

    'cache' => [
        'production' => 604800, // 1 week
        'staging' => 86400, // 1 day
        'default' => 1, // 1 second
    ],

    'services' => [
        'fathom' => [
            'url' => env('FATHOM_URL', 'https://cdn-eu.usefathom.com/script.js'),
            'site_id' => env('FATHOM_SITE_ID'),
            'environments' => ['staging', 'production'],
        ],

        'flare' => [
            'project_id' => env('FLARE_PROJECT_ID', 0),
            'key' => env('FLARE_KEY', ''),
            'enabled' => env('FLARE_ENABLED', false),
            'environments' => ['production'],
        ],

        'oh_dear' => [
            'site_id' => env('OH_DEAR_SITE_ID'),
            'key' => env('OH_DEAR_KEY'),
            'enabled' => env('OH_DEAR_ENABLED', false),
            'environments' => ['production'],
        ],

        'userback' => [
            'access_token' => env('USERBACK_ACCESS_TOKEN'),
            'enabled' => env('USERBACK_ENABLED', false),
            'environments' => ['staging', 'production'],
        ],
    ],
];
