<img src="https://banners.beyondco.de/laravel-default.png?theme=light&packageManager=composer+require&packageName=rhysleesltd%2Flaravel-default&pattern=architect&style=style_2&description=Boilerplate+integration+for+Laravel+Projects+at+Rhys+Lees+Ltd.&md=1&showWatermark=0&fontSize=100px&images=https%3A%2F%2Flaravel.com%2Fimg%2Flogomark.min.svg">

# laravel-default
[![Latest Version on Packagist](https://img.shields.io/packagist/v/rhysleesltd/laravel-default.svg?style=flat-square)](https://packagist.org/packages/rhysleesltd/laravel-default)
[![run-tests](https://github.com/rhysleesltd/laravel-default/actions/workflows/run-tests.yml/badge.svg)](https://github.com/rhysleesltd/laravel-default/actions/workflows/run-tests.yml)
[![PHPStan](https://github.com/rhysleesltd/laravel-default/actions/workflows/phpstan.yml/badge.svg)](https://github.com/rhysleesltd/laravel-default/actions/workflows/phpstan.yml)
[![GitHub Code Style Action Status](https://github.com/rhysleesltd/laravel-default/actions/workflows/fix-php-code-style-issues.yml/badge.svg)](https://github.com/rhysleesltd/laravel-default/actions/workflows/fix-php-code-style-issues.yml)
[![Total Downloads](https://img.shields.io/packagist/dt/rhysleesltd/laravel-default.svg?style=flat-square)](https://packagist.org/packages/rhysleesltd/laravel-default)

## Installation

> If using Jetstream, install Jetstream first

You can install the package via composer:

```bash
composer require rhysleesltd/laravel-default
```

```bash
php artisan default:install
```

### Meta

After you have installed the package, you should add the meta component to your layout:

```blade
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="scroll-smooth">
<head>
    <x-default::meta path="/path/to/favicons" />
```

> Ensure you remove all the default meta tags from your layouts when using the meta partial. this is due to the fact that we use seotools to set it via the Controller.

## Available Components

The package provides several Blade components that you can use in your application:

### Meta Component ⭐ (Recommended)

Sets up all the essential meta tags for SEO, Open Graph, and Twitter Cards using seotools. **This is the preferred component as it includes Fathom Analytics and other integrations automatically.**

```blade
<x-default::meta path="/path/to/favicons" />
```

**Example with color theme:**
```blade
<x-default::meta path="/favicons" color="#ff6b35" />
```

**Features:**
- SEO meta tags (title, description, keywords) via seotools
- Open Graph tags for social media sharing
- Twitter Card tags
- Complete favicon integration (PNG, SVG, ICO, Apple Touch)
- Web app manifest support
- Canonical URLs and viewport meta tags
- **Includes Fathom Analytics automatically**
- CSRF token integration

### Fathom Analytics Component

Includes Fathom Analytics tracking script with proper CSP compliance. **Note: This is automatically included when using the Meta component above.**

```blade
<x-default::fathom />
```

**Configuration:**
```bash
FATHOM_URL=https://cdn-eu.usefathom.com/script.js  # or https://cdn.usefathom.com/script.js
FATHOM_SITE_ID=your-site-id
```

**Features:**
- Environment-aware (only loads in staging/production)
- Configurable CDN endpoint (EU or Global)
- CSP compliant
- Automatic site ID injection

### Userback Component

Integrates Userback user feedback widget for authenticated users.

```blade
<x-default::userback />
```

**Configuration:**
```bash
USERBACK_ACCESS_TOKEN=your-access-token
USERBACK_ENABLED=true  # Optional, defaults to false
```

**Features:**
- Only loads for authenticated users
- Environment-aware (staging/production only)
- Configurable enable/disable toggle
- Automatic user data integration (ID, name, email)
- CSP compliant

## Packages Used

### SEO
For SEO Meta tags we use the following package:
https://github.com/artesaos/seotools

> Make sure to set the defaults in the `seotools.php` config file or titles will be incorrect

Preconfigured command `sitemap:generate` for the following:
https://github.com/spatie/laravel-sitemap

### Icons
https://github.com/blade-ui-kit/blade-icons

https://github.com/owenvoke/blade-fontawesome

## Production

Ensure you run the following command to ensure that the assets are compiled for production:

```bash
php artisan optimize

php artisan icons:cache

php artisan event:cache

php artisan sitemap:generate

php artisan oh-dear:request-run
```

### Forge Deployment Script Template

```shell
cd $FORGE_SITE_PATH

if [ -f artisan ]; then
    $FORGE_PHP artisan oh-dear:start-maintenance
    
    $FORGE_PHP artisan down --refresh=15
fi

git pull origin $FORGE_SITE_BRANCH

$FORGE_COMPOSER install --no-dev --no-interaction --prefer-dist --optimize-autoloader

( flock -w 10 9 || exit 1
    echo 'Restarting FPM...'; sudo -S service $FORGE_PHP_FPM reload ) 9>/tmp/fpmlock
    
npm install
    
npm run build

if [ -f artisan ]; then
    $FORGE_PHP artisan migrate --force
    
    $FORGE_PHP artisan optimize:clear
    $FORGE_PHP artisan optimize
    
    $FORGE_PHP artisan event:cache
    $FORGE_PHP artisan icons:cache
    
    $FORGE_PHP artisan sitemap:generate
    
    $FORGE_PHP artisan up
    
    $FORGE_PHP artisan oh-dear:stop-maintenance
    
    $FORGE_PHP artisan oh-dear:request-run
fi

rm -rf node_modules
```

## Testing

```bash
composer test
```

## Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information on what has changed recently.

## Contributing

Please see [CONTRIBUTING](https://github.com/rhysleesltd/laravel-default/blob/main/.github/CONTRIBUTING.md) for details.

## Security Vulnerabilities

Please review [our security policy](../../security/policy) on how to report security vulnerabilities.

## Credits

- [Rhys Lees](https://github.com/RhysLees)
- [All Contributors](../../contributors)

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.
