<?php

namespace RhysLeesLtd\FilamentBarcodeField;

use Filament\Support\Assets\Css;
use Filament\Support\Assets\Js;
use Filament\Support\Facades\FilamentAsset;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class FilamentBarcodeFieldServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('filament-barcode-field')
            ->hasViews();
    }

    public function packageBooted(): void
    {
        FilamentAsset::register([
            Js::make('filament-barcode-field', __DIR__.'/../dist/filament-barcode-field.js'),
            Css::make('filament-barcode-field', __DIR__.'/../dist/filament-barcode-field.css'),
        ], 'filament-barcode-field');
    }
}
