<img src="https://banners.beyondco.de/Laravel%20Filament%20Barcode%20Field.png?theme=light&packageManager=composer+require&packageName=rhysleesltd%2Ffilament-barcode-field&pattern=circuitBoard&style=style_1&description=A+Laravel+Filament+Barcode+Field+integration.&md=1&showWatermark=1&fontSize=100px&images=light-bulb">

[![Latest Version on Packagist](https://img.shields.io/packagist/v/rhysleesltd/filament-barcode-field.svg?style=flat-square)](https://packagist.org/packages/rhysleesltd/filament-barcode-field)
[![GitHub-Tests](https://github.com/rhysleesltd/filament-barcode-field/actions/workflows/run-tests.yml/badge.svg?branch=main)](https://github.com/rhysleesltd/filament-barcode-field/actions/workflows/run-tests.yml)
[![GitHub Code Style](https://github.com/rhysleesltd/filament-barcode-field/actions/workflows/fix-php-code-style-issues.yml/badge.svg?branch=main)](https://github.com/rhysleesltd/filament-barcode-field/actions/workflows/fix-php-code-style-issues.yml)
[![Total Downloads](https://img.shields.io/packagist/dt/rhysleesltd/filament-barcode-field.svg?style=flat-square)](https://packagist.org/packages/rhysleesltd/filament-barcode-field)


## 💡 What is Filament Barcode Field?

Filament Barcode Field is a field for filament designed for easy use with bluetooth barcode scanners.

## 🛠 Requirements
- Filament >= v4.0
- Laravel >= v12.0
- Barcode scanner but have the option to add atleast 1 prefix and 1 suffix to the barcode.




## ⚙️ Installation

You can install the package via composer:

```bash
composer require rhysleesltd/filament-barcode-field
php artisan filament:assets
```


## Usage

### Forms

```php
use RhysLeesLtd\FilamentBarcodeField\Forms\Components\BarcodeInput;

...

public function form(Form $form): Form
{
    return $form
        ->schema([
            // Add Barcode Form Implimentation Here
        ]);
}
```

### Infolists

```php
use RhysLeesLtd\FilamentBarcodeField\Infolists\Components\BarcodeEntry;

...

public function infolist(Infolist $infolist): Infolist
{
    return $infolist
        ->schema([
            // Add Barcode Infolist Implimentation Here
        ]);
}
```

## 🚧 Testing

Copy your own phpunit.xml-file.

```bash
cp phpunit.xml.dist phpunit.xml
```

Run the tests:

```bash
./vendor/bin/pest
```

## 🚧 Building

```bash
node bin/build
```

Note: there is no output, but the build will be in the `dist` directory.

## 📝 Changelog

Please see [CHANGELOG](CHANGELOG.md) for recent changes.

```bash
composer test
```

### Code Style

```bash
./vendor/bin/pint
```

## 🧑‍💻 Security Vulnerabilities

Please review [our security policy](.github/SECURITY.md) on reporting security vulnerabilities.

## 🙏 Credits
- [Rhys Lees](https://github.com/RhysLees)
- [All Contributors](../../contributors)
- [Skeleton Repository from Spatie](https://github.com/spatie/package-skeleton-laravel)

## 🎭 License

The MIT License (MIT). Please have a look at [License File](LICENSE.md) for more information.
