<?php

namespace RhysLeesLtd\FilamentBarcodeField\Forms\Components;

use Closure;
use Filament\Forms\Components\TextInput;

class BarcodeInput extends TextInput
{
    protected string $view = 'filament-barcode-field::forms.components.barcode-input';

    protected bool|Closure $hasBarcodePrefix = true;

    protected bool|Closure $hasBarcodeSuffix = true;

    public static function getAssetPackageName(): ?string
    {
        return 'filament-barcode-field';
    }

    public function setUp(): void
    {
        parent::setUp();
    }

    public function barcodePrefix(bool|Closure $condition = true): static
    {
        $this->hasBarcodePrefix = $condition;

        return $this;
    }

    public function getHasBarcodePrefix(): bool
    {
        return (bool) $this->evaluate($this->hasBarcodePrefix);
    }

    public function barcodeSuffix(bool|Closure $condition = true): static
    {
        $this->hasBarcodeSuffix = $condition;

        return $this;
    }

    public function getHasBarcodeSuffix(): bool
    {
        return (bool) $this->evaluate($this->hasBarcodeSuffix);
    }
}
