<x-dynamic-component
    :component="$getFieldWrapperView()"
    :field="$field"
>
    {{-- Load script synchronously so barcodeScanner is registered before Alpine runs --}}
    <script src="{{ \Filament\Support\Facades\FilamentAsset::getScriptSrc('filament-barcode-field-alpine', package: 'rhysleesltd/filament-barcode-field') }}"></script>
    <div
        x-data="barcodeScanner('{{ $getHasBarcodePrefix() ? '~' : '' }}', '{{ $getHasBarcodeSuffix() ? '*' : '' }}')"
        @barcode-scanned="$wire.set('{{ $getStatePath() }}', $event.detail.barcode)"
    >
        <div x-data="{ state: $wire.{{ $applyStateBindingModifiers("\$entangle('{$getStatePath()}')") }} }">
            <x-filament::input.wrapper
                :valid="! $getStatePath() || ! $errors->has($getStatePath())"
                :disabled="$isDisabled()"
            >
                <x-filament::input
                    type="text"
                    :id="$getId()"
                    x-model="state"
                    :placeholder="$getPlaceholder()"
                    :disabled="$isDisabled()"
                />
            </x-filament::input.wrapper>
        </div>
    </div>
</x-dynamic-component>
