<?php

namespace Andreia\FilamentBusinessHours\Tables\Columns;

use Andreia\FilamentBusinessHours\Enums\Days;
use Filament\Tables\Columns\Column;

class BusinessHoursColumn extends Column
{
    protected string $view = 'filament-business-hours::tables.columns.business-hours';

    public function getState(): mixed
    {
        $state = parent::getState();

        if (is_string($state)) {
            $state = json_decode($state, true);
        }

        return [
            'days' => Days::toShortArray(),
            'hours' => $state['hours'] ?? [],
        ];
    }
}
