<?php

namespace Andreia\FilamentBusinessHours\Infolists\Components;

use Andreia\FilamentBusinessHours\Enums\Days;
use Filament\Infolists\Components\Entry;

class BusinessHoursEntry extends Entry
{
    protected string $view = 'filament-business-hours::infolists.components.business-hours-entry';

    public function getState(): mixed
    {
        $state = parent::getState();

        if (is_string($state)) {
            $state = json_decode($state, true);
        }

        return [
            'days' => Days::toArray(),
            'enabled' => $state['enabled'] ?? false,
            'timezone' => $state['timezone'] ?? null,
            'hours' => $state['hours'] ?? [],
            'exceptions' => $state['exceptions'] ?? [],
        ];
    }
}
