<?php

namespace Andreia\FilamentBusinessHours\Enums;

enum Days: string
{
    case MONDAY = 'monday';
    case TUESDAY = 'tuesday';
    case WEDNESDAY = 'wednesday';
    case THURSDAY = 'thursday';
    case FRIDAY = 'friday';
    case SATURDAY = 'saturday';
    case SUNDAY = 'sunday';

    public function label(): string
    {
        return match ($this) {
            self::MONDAY => __('filament-business-hours::business-hours.days.monday'),
            self::TUESDAY => __('filament-business-hours::business-hours.days.tuesday'),
            self::WEDNESDAY => __('filament-business-hours::business-hours.days.wednesday'),
            self::THURSDAY => __('filament-business-hours::business-hours.days.thursday'),
            self::FRIDAY => __('filament-business-hours::business-hours.days.friday'),
            self::SATURDAY => __('filament-business-hours::business-hours.days.saturday'),
            self::SUNDAY => __('filament-business-hours::business-hours.days.sunday'),
        };
    }

    public function shortLabel(): string
    {
        return match ($this) {
            self::MONDAY => __('filament-business-hours::business-hours.days_short.monday'),
            self::TUESDAY => __('filament-business-hours::business-hours.days_short.tuesday'),
            self::WEDNESDAY => __('filament-business-hours::business-hours.days_short.wednesday'),
            self::THURSDAY => __('filament-business-hours::business-hours.days_short.thursday'),
            self::FRIDAY => __('filament-business-hours::business-hours.days_short.friday'),
            self::SATURDAY => __('filament-business-hours::business-hours.days_short.saturday'),
            self::SUNDAY => __('filament-business-hours::business-hours.days_short.sunday'),
        };
    }

    public static function toArray(): array
    {
        return collect(self::cases())
            ->mapWithKeys(fn (Days $day) => [$day->value => $day->label()])
            ->toArray();
    }

    public static function toShortArray(): array
    {
        return collect(self::cases())
            ->mapWithKeys(fn (Days $day) => [$day->value => $day->shortLabel()])
            ->toArray();
    }

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }
}
