<div class="flex gap-1">
    @foreach($getState()['days'] as $day => $shortName)
        @php
            $hours = $getState()['hours'][$day] ?? [];
            $isEnabled = !empty($hours);
            
            $timeRanges = [];
            if ($isEnabled) {
                foreach ($hours as $timeRange) {
                    $timeRanges[] = $timeRange;
                }
            }
            
            $tooltip = $isEnabled 
                ? implode(', ', $timeRanges)
                : __('filament-business-hours::business-hours.closed');
        @endphp

        <div 
            @class([
                'flex items-center justify-center w-8 h-8 rounded-full text-xs font-medium',
                'bg-primary-500' => $isEnabled,
                'bg-gray-200 dark:bg-gray-500' => ! $isEnabled,
                'text-gray-600' => $isEnabled,
                'text-gray-400 dark:text-gray-200' => ! $isEnabled,
            ])
            x-data
            x-tooltip.raw="{{ $tooltip }}"
        >
            {{ $shortName }}
        </div>
    @endforeach
</div>
