<x-dynamic-component :component="$getEntryWrapperView()" :entry="$entry">
    <div class="space-y-4">
        {{-- Business Status --}}
        <div class="mb-4">
            <div class="flex items-center space-x-2">
                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white w-32 px-2">{{ __('filament-business-hours::business-hours.infolist.status') }}</span>
                <span @class([
                    'text-sm',
                    'text-success-600' => $getState()['enabled'],
                    'text-gray-500' => ! $getState()['enabled'],
                ])>
                    {{ $getState()['enabled'] ? __('filament-business-hours::business-hours.infolist.enabled') : __('filament-business-hours::business-hours.infolist.disabled') }}
                </span>
            </div>
            
            @if(!empty($getState()['timezone']))
                <div class="flex items-center space-x-2 mt-1">
                    <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white w-32 px-2">{{ __('filament-business-hours::business-hours.infolist.timezone') }}</span>
                    <span class="text-sm leading-6 text-gray-700">{{ str_replace('_', ' ', $getState()['timezone']) }}</span>
                </div>
            @endif
        </div>

        {{-- Hours Section --}}
        <div class="space-y-2">
            <h3 class="text-sm font-medium leading-6 text-gray-950 dark:text-white">{{ __('filament-business-hours::business-hours.infolist.opening_hours') }}</h3>
            
            @foreach($getState()['days'] as $day => $label)
                <div class="flex items-start space-x-2">
                    <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white w-32 px-2">{{ $label }}:</span>
                    
                    @if(empty($getState()['hours'][$day]))
                        <div class="flex items-center text-gray-500">
                            <x-filament::icon
                                icon="heroicon-o-moon"
                                class="h-4 w-4 text-gray-500 dark:text-gray-400"
                            />
                            <span class="text-sm leading-6 text-gray-500 px-2">{{ __('filament-business-hours::business-hours.closed') }}</span>
                        </div>
                    @else
                        <div class="text-sm leading-6 text-gray-700">
                            {{ implode(', ', $getState()['hours'][$day]) }}
                        </div>
                    @endif
                </div>
            @endforeach
        </div>

        {{-- Exceptions Section --}}
        @if(!empty($getState()['exceptions']))
            <div class="mt-6 space-y-2">
                <h3 class="text-sm font-medium leading-6 text-gray-950 dark:text-white">{{ __('filament-business-hours::business-hours.infolist.exceptions') }}</h3>
                
                @foreach($getState()['exceptions'] as $date => $exception)
                    <div class="flex items-center space-x-2">
                        <div class="text-sm font-medium leading-6 text-gray-950 dark:text-white px-2">{{ $date }}</div>
                        
                        @php
                            $exceptionHours = __('filament-business-hours::business-hours.infolist.all_day');

                            if (! empty($exception['hours'])) {
                                $exceptionHours = implode(', ', $exception['hours']);
                            }
                        @endphp
                        
                        <div class="text-sm leading-6 text-gray-700">{{ $exceptionHours }}</div>
                        
                        @if(! empty($exception['data']))
                            <div class="text-sm leading-6 text-gray-500 px-2">- {{ $exception['data'] }}</div>
                        @endif
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</x-dynamic-component>
